/*
 * Decompiled with CFR 0.152.
 */
package javajs.util;

import java.io.BufferedReader;
import java.util.Hashtable;
import java.util.Map;
import javajs.api.GenericCifDataParser;
import javajs.api.GenericLineReader;
import javajs.util.Lst;
import javajs.util.PT;
import javajs.util.SB;

public class CifDataParser
implements GenericCifDataParser {
    private GenericLineReader reader;
    private BufferedReader br;
    private String line;
    private String str;
    private int ich;
    private int cch;
    private boolean wasUnQuoted;
    private String strPeeked;
    private int ichPeeked;
    private int fieldCount;
    private String[] loopData;
    private SB fileHeader = new SB();
    private boolean isHeader = true;
    private String nullString = "\u0000";
    private static Map<String, Integer> htFields = new Hashtable<String, Integer>();
    private String[] fields;
    private static final String grABC = "ABX\u0394E\u03a6\u0393HI_K\u039bMNO\u03a0\u0398P\u03a3TY_\u03a9\u039e\u03a5Z";
    private static final String grabc = "\u03b1\u03b2\u03c7\u03a4\u03a5\u03c6\u03b3\u03b7\u03b9_\u03ba\u03bb\u03bc\u03bd\u03bf\u03c0\u03b8\u03c1\u03c3\u03c4\u03c5_\u03c9\u03be\u03c5\u03b6";

    public void setNullValue(String string) {
        this.nullString = string;
    }

    @Override
    public String getLoopData(int n) {
        return this.loopData[n];
    }

    @Override
    public int getFieldCount() {
        return this.fieldCount;
    }

    @Override
    public String getField(int n) {
        return this.fields[n];
    }

    @Override
    public CifDataParser set(GenericLineReader genericLineReader, BufferedReader bufferedReader) {
        this.reader = genericLineReader;
        this.br = bufferedReader;
        return this;
    }

    @Override
    public String getFileHeader() {
        return this.fileHeader.toString();
    }

    @Override
    public Map<String, Object> getAllCifData() {
        this.line = "";
        Hashtable<String, Object> hashtable = null;
        Hashtable<String, Object> hashtable2 = new Hashtable<String, Object>();
        Lst<Hashtable<String, Object>> lst = new Lst<Hashtable<String, Object>>();
        hashtable2.put("models", lst);
        try {
            String string;
            while ((string = this.getNextToken()) != null) {
                if (string.startsWith("global_") || string.startsWith("data_")) {
                    hashtable = new Hashtable<String, Object>();
                    lst.addLast(hashtable);
                    hashtable.put("name", string);
                    continue;
                }
                if (string.startsWith("loop_")) {
                    this.getAllCifLoopData(hashtable);
                    continue;
                }
                if (string.charAt(0) != '_') {
                    System.out.println("CIF ERROR ? should be an underscore: " + string);
                    continue;
                }
                String string2 = this.getNextToken();
                if (string2 == null) {
                    System.out.println("CIF ERROR ? end of file; data missing: " + string);
                    continue;
                }
                hashtable.put(this.fixKey(string), string2);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (this.br != null) {
                this.br.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return hashtable2;
    }

    private void getAllCifLoopData(Map<String, Object> map) throws Exception {
        String string;
        Lst<String> lst = new Lst<String>();
        while ((string = this.peekToken()) != null && string.charAt(0) == '_') {
            string = this.fixKey(this.getTokenPeeked());
            lst.addLast(string);
            map.put(string, new Lst());
        }
        this.fieldCount = lst.size();
        if (this.fieldCount == 0) {
            return;
        }
        this.loopData = new String[this.fieldCount];
        while (this.getData()) {
            for (int i = 0; i < this.fieldCount; ++i) {
                ((Lst)map.get(lst.get(i))).addLast(this.loopData[i]);
            }
        }
    }

    @Override
    public String readLine() {
        try {
            String string = this.line = this.reader == null ? this.br.readLine() : this.reader.readNextLine();
            if (this.line == null) {
                return null;
            }
            if (this.isHeader) {
                if (this.line.startsWith("#")) {
                    this.fileHeader.append(this.line).appendC('\n');
                } else {
                    this.isHeader = false;
                }
            }
            return this.line;
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public boolean getData() throws Exception {
        for (int i = 0; i < this.fieldCount; ++i) {
            this.loopData[i] = this.getNextDataToken();
            if (this.loopData[i] != null) continue;
            return false;
        }
        return this.fieldCount > 0;
    }

    @Override
    public void skipLoop() throws Exception {
        String string;
        while ((string = this.peekToken()) != null && string.charAt(0) == '_') {
            this.getTokenPeeked();
        }
        while (this.getNextDataToken() != null) {
        }
    }

    @Override
    public String getNextToken() throws Exception {
        while (!this.strHasMoreTokens()) {
            if (this.setStringNextLine() != null) continue;
            return null;
        }
        return this.nextStrToken();
    }

    @Override
    public String getNextDataToken() throws Exception {
        String string = this.peekToken();
        if (string == null) {
            return null;
        }
        if (this.wasUnQuoted && (string.charAt(0) == '_' || string.startsWith("loop_") || string.startsWith("data_") || string.startsWith("stop_") || string.startsWith("global_"))) {
            return null;
        }
        return this.getTokenPeeked();
    }

    @Override
    public String peekToken() throws Exception {
        while (!this.strHasMoreTokens()) {
            if (this.setStringNextLine() != null) continue;
            return null;
        }
        int n = this.ich;
        this.strPeeked = this.nextStrToken();
        this.ichPeeked = this.ich;
        this.ich = n;
        return this.strPeeked;
    }

    @Override
    public String getTokenPeeked() {
        this.ich = this.ichPeeked;
        return this.strPeeked;
    }

    @Override
    public String fullTrim(String string) {
        int n = -1;
        int n2 = string.length();
        while (++n < n2 && PT.isWhitespace(string.charAt(n))) {
        }
        while (--n2 > n && PT.isWhitespace(string.charAt(n2))) {
        }
        return string.substring(n, n2 + 1);
    }

    @Override
    public String toUnicode(String string) {
        try {
            int n;
            while ((n = string.indexOf(92)) >= 0) {
                char c = string.charAt(n + 1);
                String string2 = c >= 'A' && c <= 'Z' ? grABC.substring(c - 65, c - 64) : (c >= 'a' && c <= 'z' ? grabc.substring(c - 97, c - 96) : "_");
                string = string.substring(0, n) + string2 + string.substring(n + 2);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string;
    }

    @Override
    public int parseLoopParameters(String[] stringArray, int[] nArray, int[] nArray2) throws Exception {
        int n = 0;
        if (stringArray == null) {
            this.fields = new String[100];
        } else {
            int n2;
            if (!htFields.containsKey(stringArray[0])) {
                n2 = stringArray.length;
                while (--n2 >= 0) {
                    htFields.put(stringArray[n2], n2);
                }
            }
            n2 = stringArray.length;
            while (--n2 >= 0) {
                nArray[n2] = -1;
            }
            n = stringArray.length;
        }
        this.fieldCount = 0;
        while (true) {
            int n3;
            String string;
            if ((string = this.peekToken()) == null) {
                this.fieldCount = 0;
                break;
            }
            if (string.charAt(0) != '_') break;
            ++this.fieldCount;
            string = this.fixKey(this.getTokenPeeked());
            if (stringArray == null) {
                nArray2[n3] = nArray[n3] = n3;
                this.fields[nArray[n3]] = string;
                continue;
            }
            Integer n4 = htFields.get(string);
            int n5 = n4 == null ? -1 : n4;
            nArray2[n3] = n5;
            if (nArray2[n3] == -1) continue;
            nArray[n5] = n3;
        }
        if (this.fieldCount > 0) {
            this.loopData = new String[this.fieldCount];
        }
        return n;
    }

    @Override
    public String fixKey(String string) {
        return PT.rep(string.startsWith("_magnetic") ? string.substring(9) : (string.startsWith("_jana") ? string.substring(5) : string), ".", "_").toLowerCase();
    }

    private void setString(String string) {
        this.str = this.line = string;
        this.cch = string == null ? 0 : string.length();
        this.ich = 0;
    }

    private String setStringNextLine() throws Exception {
        this.setString(this.readLine());
        if (this.line == null || this.line.length() == 0) {
            return this.line;
        }
        if (this.line.charAt(0) != ';') {
            if (this.str.startsWith("###non-st#")) {
                this.ich = 10;
            }
            return this.line;
        }
        this.ich = 1;
        String string = '\u0001' + this.line.substring(1) + '\n';
        while (this.readLine() != null) {
            if (this.line.startsWith(";")) {
                string = string.substring(0, string.length() - 1) + '\u0001' + this.line.substring(1);
                break;
            }
            string = string + this.line + '\n';
        }
        this.setString(string);
        return string;
    }

    private boolean strHasMoreTokens() {
        if (this.str == null) {
            return false;
        }
        int n = 35;
        while (this.ich < this.cch) {
            char c = this.str.charAt(this.ich);
            n = c;
            if (c != ' ' && n != 9) break;
            ++this.ich;
        }
        return this.ich < this.cch && n != 35;
    }

    private String nextStrToken() {
        if (this.ich == this.cch) {
            return null;
        }
        int n = this.ich;
        char c = this.str.charAt(n);
        if (c != '\'' && c != '\"' && c != '\u0001') {
            this.wasUnQuoted = true;
            while (this.ich < this.cch && (c = this.str.charAt(this.ich)) != ' ' && c != '\t') {
                ++this.ich;
            }
            if (this.ich == n + 1 && this.nullString != null && (this.str.charAt(n) == '.' || this.str.charAt(n) == '?')) {
                return this.nullString;
            }
            String string = this.str.substring(n, this.ich);
            return string;
        }
        this.wasUnQuoted = false;
        char c2 = c;
        boolean bl = false;
        while (++this.ich < this.cch) {
            c = this.str.charAt(this.ich);
            if (bl && (c == ' ' || c == '\t')) break;
            bl = c == c2;
        }
        if (this.ich == this.cch) {
            if (bl) {
                return this.str.substring(n + 1, this.ich - 1);
            }
            return this.str.substring(n, this.ich);
        }
        ++this.ich;
        return this.str.substring(n + 1, this.ich - 2);
    }
}

