/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.shapespecial;

import javax.vecmath.Point3f;
import javax.vecmath.Point3i;
import org.jmol.g3d.Graphics3D;
import org.jmol.modelset.Atom;
import org.jmol.shape.ShapeRenderer;
import org.jmol.shapespecial.Polyhedra;

public class PolyhedraRenderer
extends ShapeRenderer {
    private int drawEdges;
    private boolean isAll;
    private boolean frontOnly;

    protected void render() {
        Polyhedra polyhedra = (Polyhedra)this.shape;
        Polyhedra.Polyhedron[] polyhedronArray = polyhedra.polyhedrons;
        this.drawEdges = polyhedra.drawEdges;
        short[] sArray = polyhedra.colixes;
        Point3i[] point3iArray = null;
        int n = polyhedra.polyhedronCount;
        while (--n >= 0) {
            int n2 = polyhedronArray[n].centralAtom.getIndex();
            short s = sArray == null || n2 >= sArray.length ? (short)0 : polyhedra.colixes[n2];
            point3iArray = this.render1(polyhedronArray[n], s, point3iArray);
        }
    }

    private Point3i[] render1(Polyhedra.Polyhedron polyhedron, short s, Point3i[] point3iArray) {
        int n;
        if (polyhedron.visibilityFlags == 0) {
            return point3iArray;
        }
        s = Graphics3D.getColixInherited((short)s, (short)polyhedron.centralAtom.getColix());
        Point3f[] point3fArray = polyhedron.vertices;
        if (point3iArray == null || point3iArray.length < point3fArray.length) {
            point3iArray = new Point3i[point3fArray.length];
            n = point3fArray.length;
            while (--n >= 0) {
                point3iArray[n] = new Point3i();
            }
        }
        byte[] byArray = polyhedron.planes;
        n = point3fArray.length;
        while (--n >= 0) {
            Atom atom;
            Atom atom2 = atom = point3fArray[n] instanceof Atom ? (Atom)point3fArray[n] : null;
            if (atom == null) {
                this.viewer.transformPoint(point3fArray[n], point3iArray[n]);
                continue;
            }
            point3iArray[n].set(atom.screenX, atom.screenY, atom.screenZ);
        }
        this.isAll = this.drawEdges == 1;
        boolean bl = this.frontOnly = this.drawEdges == 2;
        if (this.g3d.setColix(s)) {
            n = 0;
            int n2 = 0;
            while (n2 < byArray.length) {
                this.fillFace(polyhedron.normixes[n++], point3iArray[byArray[n2++]], point3iArray[byArray[n2++]], point3iArray[byArray[n2++]]);
            }
        }
        if (this.g3d.setColix(Graphics3D.getColixTranslucent((short)s, (boolean)false, (float)0.0f))) {
            n = 0;
            int n3 = 0;
            while (n3 < byArray.length) {
                this.drawFace(polyhedron.normixes[n++], point3iArray[byArray[n3++]], point3iArray[byArray[n3++]], point3iArray[byArray[n3++]]);
            }
        }
        return point3iArray;
    }

    private void drawFace(short s, Point3i point3i, Point3i point3i2, Point3i point3i3) {
        if (this.isAll || this.frontOnly && this.g3d.isDirectedTowardsCamera(s)) {
            this.drawCylinderTriangle(point3i.x, point3i.y, point3i.z, point3i2.x, point3i2.y, point3i2.z, point3i3.x, point3i3.y, point3i3.z);
        }
    }

    private void drawCylinderTriangle(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        this.g3d.fillCylinderScreen((byte)3, 3, n, n2, n3, n4, n5, n6);
        this.g3d.fillCylinderScreen((byte)3, 3, n4, n5, n6, n7, n8, n9);
        this.g3d.fillCylinderScreen((byte)3, 3, n, n2, n3, n7, n8, n9);
    }

    private void fillFace(short s, Point3i point3i, Point3i point3i2, Point3i point3i3) {
        this.g3d.fillTriangleTwoSided(s, point3i.x, point3i.y, point3i.z, point3i2.x, point3i2.y, point3i2.z, point3i3.x, point3i3.y, point3i3.z);
    }
}

